package com.biz.crm.excel.consumer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.Result;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

/**
 * @Description: excel-export 监听消息
 * @project：crm
 * @package：com.biz.crm.excel.consumer
 * @author：lifei
 * @create：2020/12/10 10:41 上午
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.WEBSOCKET_SESSION,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.WEBSOCKET_SESSION + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY)
public class ExcelExportConsumer extends AbstractRocketMQConsumer {

    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();

    @Autowired
    private IExcelService excelExportService;

    //获取消息
    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String result = message.getMsgBody();
        log.info("接收消息:{}",result);
        JSONObject jsonObject = JSONObject.parseObject(result);
        String clientId = jsonObject.get("sid").toString();
        String websocketMessage = jsonObject.getString("websocketMessage");
        Boolean flag = userWebSocketHandler.getWebSocketSession(clientId);
        if (flag){
            //发送消息
            userWebSocketHandler.sendMessageToUser(clientId,new TextMessage(JSONObject.toJSONString(Result.ok(websocketMessage))));
        }
        return jsonObject;
    }
}
