package com.biz.crm.excel.consumer;

import com.biz.crm.excel.util.MqMessageParam;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.websocket.user.endpoint.UserWebSocketHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;

/**
 * @Description: excel-export 监听消息
 * @project：crm
 * @package：com.biz.crm.excel.consumer
 * @author：lifei
 * @create：2020/12/10 10:41 上午
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.EXCEL_IMPORT_WEBSOCKET_MSG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.EXCEL_IMPORT_WEBSOCKET_MSG + "${rocketmq.environment-variable}",
        /**
         * 默认集群消费， 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY)
public class ExcelImportWebsocketMsgConsumer implements RocketMQListener<RocketMQMessageBody> {

    private static UserWebSocketHandler userWebSocketHandler = new UserWebSocketHandler();


    //获取消息
    @Override
    public void onMessage(RocketMQMessageBody message){
        if(log.isInfoEnabled()){
            log.info("发送excel导入消息>>>" + message.getMsgBody());
        }
        MqMessageParam mqMessageParam = JsonPropertyUtil.toObject(message.getMsgBody(), MqMessageParam.class);
        if(null == mqMessageParam){
            if(log.isWarnEnabled()){
                log.warn("发送excel导入消息失败 mqMessageParam = null >>> " + message.getMsgBody());
            }
            return;
        }
        Boolean flag = userWebSocketHandler.getWebSocketSession(mqMessageParam.getClientId());
        if(flag){
            TextMessage textMessage = new TextMessage(mqMessageParam.getMsg());
            userWebSocketHandler.sendMessageToUser(mqMessageParam.getClientId(), textMessage);
        }
        if(log.isInfoEnabled()){
            log.info("发送excel导入消息>>> flag = " + flag);
        }
    }
}
