package com.biz.crm.excel.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.excel.component.saver.ExcelImportSaver;
import com.biz.crm.excel.service.IExcelService;
import com.biz.crm.excel.util.DefaultImportContext;
import com.biz.crm.excel.vo.tpm.FeeBudgetImportVo;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.excel.controller
 * @author：lifei
 * @create：2020/12/6 5:37 下午
 */
@Slf4j
@RestController
@RequestMapping("/excelController")
@Api(tags = "excel导入导出 ")
public class ExcelController {

    @Resource
    private IExcelService excelService;

    @Resource(name="tpmFeeBudgetImportSavor")
    private ExcelImportSaver saver;

    /**
     * excel动态导出
     * @return
     */
    @ApiOperation(value = "动态导出excel")
    @PostMapping("/repeatedWriteExport")
    @CrmLog
    public Result repeatedWriteExport(@RequestBody HashMap<String, Object> requestParamMap){
        excelService.repeatedWriteExport(requestParamMap);
        return Result.ok();
    }
    /**
     * excel动态导出
     * @return
     */
    @ApiOperation(value = "测试")
    @GetMapping("/test")
    @CrmLog
    public Result test(){
        DefaultImportContext context=new DefaultImportContext();
        List<FeeBudgetImportVo> data=Lists.newArrayList();
        FeeBudgetImportVo vo = new FeeBudgetImportVo();
        vo.setBudgetYear("2021");
        vo.setBudgetMonth("1");
        vo.setBudgetSubjectsCode("121");
        vo.setProjectNumber("zb0222");
        vo.setOrgCode("CRM001");
        vo.setInitAmount("40000");
        data.add(vo);
        saver.save(data,context);
        return Result.ok();
    }
}
