package com.biz.crm.excel.controller.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 导入请求参数对象
 *  @author: luoqi
 *  @Date: 2020-12-9 19:40
 *  @version: V1.0
 *  @Description:
 */
@ApiModel("导入请求参数对象")
@Data
public class ExcelImportParamVo {
    //文件中心任务id
    private String taskId;
    //文件中心任务编码（页面上是查询条件id）
    private String taskCode;
    //导入配置编码
    private String importConfigCode;
    //webSocketClientId
    @ApiModelProperty("webSocket连接id")
    private String webSocketClientId;

    @ApiModelProperty("测试模式")
    private Boolean test;

    @ApiModelProperty("保存逻辑的bean name")
    private String beanNameAsSaver;

    @ApiModelProperty("校验逻辑的bean name")
    private String beanNameAsValidator;

//    @ApiModelProperty("事务管理器的bean name")
//    private String beanNameAsTransactionManager;

    @ApiModelProperty("excel 行解析类路径")
    private String classPathAsImportVo;

    @ApiModelProperty("示例文件名")
    private String fileNameAsDemo;
    @ApiModelProperty("导入模式")
    private ImportMode importMode = ImportMode.ASYNC;

    @ApiModelProperty("自定义扩展参数")
    private String bizParams;

    public enum ImportMode{
        /** 异步导入 **/
        ASYNC,
        /** 非异步导入（同步） **/
        UN_ASYNC,
    }
}
