package com.biz.crm.excel.demo.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.entity
 * @Description: TODO
 * @date 2020/10/17 下午5:24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("upload_file")
@ApiModel("文件上传信息")
public class UploadFileEntity extends BaseIdEntity {
    private static final long serialVersionUID = -3517167521124118330L;

    /**
     * 创建时间 yyyy-mm-dd
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createDate;
    /**
     * 创建时间 hh:mm:ss
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createDateSecond;

    /**
     * 创建人账号
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createCode;

    /**
     * 创建人名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createName;

    /**
     * 创建人组织编码
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createOrgCode;

    /**
     * 创建人组织名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createOrgName;

    /**
     * 创建人职位code
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createPosCode;

    /**
     * 创建人职位名称
     */
    @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY)
    private String createPosName;
    /**
     * 对象名称
     */
    private String objectName;
    /**
     * 文件绝对路径
     */
    private String filePath;
    /**
     * 文件名真实名称
     */
    private String fileName;
}
