package com.biz.crm.excel.service;

import com.biz.crm.excel.controller.req.ExcelImportParamVo;
import com.biz.crm.excel.controller.resp.DemoFileResp;
import com.biz.crm.excel.controller.resp.UnAsyncImportRespVo;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;


/**
 * Excel 导入
 *  @author: luoqi
 *  @Date: 2020-12-8 14:40
 *  @version: V1.0
 *  @Description:
 */
public interface ExcelImport {
    /**
     *异步导入
     * @param paramVo
     */
    void doAsyncImport(ExcelImportParamVo paramVo, String token, File file);
    /**
     *同步导入excel(不会保存到数据库)
     * @param importParamVo
     */
    UnAsyncImportRespVo doUnAsyncImport(ExcelImportParamVo importParamVo, File file);
    /**
     * 解析配置
     * @param configCode
     * @return
     */
    ExcelImportParamVo resolveConfig(String configCode);

    /**
     * 下载示例文件
     * @param importConfigCode
     */
    DemoFileResp demoFile(String importConfigCode);
}
