package com.biz.crm.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.SimpleColumnWidthStyleStrategy;
import com.biz.crm.base.BusinessException;
import com.biz.crm.excel.component.export.extend.head.ExportHeadExtend;
import com.biz.crm.excel.controller.req.ExportParamVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnExportRespVo;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.util.PageDataAdviser;
import com.google.common.collect.Maps;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;


/**
 * 当前导出任务上下文
 *
 * @author: luoqi
 * @Date: 2021-1-5 11:37
 * @version: V1.0
 * @Description:
 */
public class DefaultExportContext {
    @Getter
    @Setter
    private Long pageTotal;
    /**
     * 已写入数量
     */
    @Getter
    private Long writtenNo = 0L;

    /**
     * 增加已写入数量
     *
     * @param add
     * @return
     */
    public Long addWrittenNo(int add) {
        this.writtenNo = writtenNo + add;
        return this.writtenNo;
    }

    /**
     * 分页工具
     */
    @Getter
    @Setter
    private PageDataAdviser pageDataAdviser;
    /**
     * 创建任务的时间
     */
    @Getter
    private LocalDateTime taskCreatedTime = LocalDateTime.now();
    /**
     * 创建任务开始执行的时间
     */
    @Getter
    @Setter
    private LocalDateTime taskBeginTime;
    /**
     * 创建任务结束的时间
     */
    @Getter
    @Setter
    private LocalDateTime taskEndTime;
    /**
     * 当前导出任务的会话 token
     */
    @Getter
    @Setter
    private String loginUserToken;
    /**
     * 封装好的配置参数，由 requestParamMap 转化而来
     */
    @Getter
    @Setter
    private ExportParamVo exportParam;

    /**
     * 当前导出任务请求参数
     */
    @Getter
    private HashMap<String, Object> requestParamMap;

    public void setRequestParamMap(HashMap<String, Object> requestParamMap) {
        HashMap<String, Object> requestParamMapTemp = Maps.newHashMap();

        if (null != requestParamMap) {
            requestParamMap.remove("parentCode");
            requestParamMap.remove("functionCode");
            requestParamMap.forEach((k, v) -> {
                if (null != v && StringUtils.isNotBlank(v.toString())) {
                    requestParamMapTemp.put(k, v);
                }
            });
        }
        this.requestParamMap = requestParamMapTemp;

    }

    /**
     * 导出列头扩展
     */
    @Getter
    @Setter
    private ExportHeadExtend headExtend;
    /**
     * 文件中心任务id（文件中心页面上不要用这个查）
     */
    @Getter
    @Setter
    private String taskId;

    /**
     * 文件中心任务编码（文件中心页面上可以用这个查）
     */
    @Getter
    @Setter
    private String taskCode;

    /**
     * 导出的文件名称
     */
    @Getter
    @Setter
    private String excelFileName;
    /**
     * 功能名称
     */
    @Getter
    @Setter
    private String functionName;

    /**
     * 功能名称
     */
    @Getter
    @Setter
    private UploadVo uploadVo;
    /**
     * 错误信息
     */
    @Getter
    @Setter
    private String errorInfo;
    /**
     * 导出列头配置
     */
    @Getter
    @Setter
    private LinkedHashMap<String, MdmColumnExportRespVo> headMap;

    @Setter
    private WriteSheet writeSheet;

    public WriteSheet getWriteSheet() {
        if (null == this.writeSheet) {
            this.writeSheet = this.buildWriteSheet();
        }
        return this.writeSheet;
    }

    private WriteSheet buildWriteSheet() {
        // 头的策略
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        //设置背景颜色
        headWriteCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints((short) 15);
        headWriteFont.setColor(IndexedColors.BLACK.getIndex());
        headWriteCellStyle.setWriteFont(headWriteFont);
        // 内容的策略
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        // 这里需要指定 FillPatternType 为FillPatternType.SOLID_FOREGROUND 不然无法显示背景颜色.头默认了 FillPatternType所以可以不指定
        contentWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        // 背景白色
        contentWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
        WriteFont contentWriteFont = new WriteFont();
        // 字体大小
        contentWriteFont.setFontHeightInPoints((short) 10);
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        //设置边框样式
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        // 这个策略是 头是头的样式 内容是内容的样式 其他的策略可以自己实现
        HorizontalCellStyleStrategy horizontalCellStyleStrategy =
                new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
        SimpleColumnWidthStyleStrategy simpleColumnWidthStyleStrategy = new SimpleColumnWidthStyleStrategy(25);
        if (StringUtils.isBlank(this.functionName)) {
            throw new BusinessException("功能名称不能为空");
        }
        return EasyExcel.writerSheet(this.functionName)
                .registerWriteHandler(simpleColumnWidthStyleStrategy)
                .registerWriteHandler(horizontalCellStyleStrategy).build();
    }

    /**
     * 导出列头扩展数量
     */
    @Getter
    @Setter
    private Integer headVariableSum = 0;
}
