package com.biz.crm.excel.util;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@Slf4j
public class ExcelImportUtil {
    private ExcelImportUtil(){}
    public static File writeFile(String excelFileName, Class classObj, ExcelTypeEnum excelTypeEnum, List<?> data, Set<String> excludeColumnFiledNames){
        File file = null;
        try {
            file = File.createTempFile(excelFileName, excelTypeEnum.getValue());
        } catch (IOException e) {
            log.warn("创建临时文件失败", e);
            throw new BusinessException("创建临时文件失败，请重试！", e);
        }

        // 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭
        ExcelWriterBuilder excelWriterBuilder = EasyExcel.write(file, classObj);
        if(!CollectionUtils.isEmpty(excludeColumnFiledNames)){
            excelWriterBuilder = excelWriterBuilder.excludeColumnFiledNames(excludeColumnFiledNames);
        }
        excelWriterBuilder.sheet("sheet1").doWrite(data);
        return file;
    }

    /**
     * 导入临时组装websocket data数据
     *
     * @param msg
     * @return
     */
    public static String importSocketMsgGenerate(String msg) {
        JSONObject requestParam = new JSONObject();
        requestParam.put("code", 200);
        requestParam.put("message", msg);
        return JSONObject.toJSONString(requestParam);
    }
}
