package com.biz.crm.excel.util;


import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.excel.component.ExportHelper;
import com.biz.crm.nebular.upload.vo.UploadVo;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;

/**
 * 导出线程逻辑
 *  @author: luoqi
 *  @Date: 2021-1-29 20:19
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
public class ExportTaskThread extends Thread {


    private DefaultExportContext exportContext;
    private ExportHelper exportHelper = SpringApplicationContextUtil.getApplicationContext().getBean("exportHelper", ExportHelper.class);
    private ExcelExportUtil excelExportUtil = SpringApplicationContextUtil.getApplicationContext().getBean("excelExportUtil", ExcelExportUtil.class);

    private String EXCEL_DOWNLOAD_URL;

    public ExportTaskThread(DefaultExportContext exportContext, String EXCEL_DOWNLOAD_URL){
        super();
        this.exportContext = exportContext;
        this.EXCEL_DOWNLOAD_URL = EXCEL_DOWNLOAD_URL;
        this.check();
    }
    private void check(){
        if(null == this.exportContext){
            throw new BusinessException("创建任务失败，非法的初始化参数数据[exportContext]");
        }
        if(StringUtils.isBlank(this.EXCEL_DOWNLOAD_URL)){
            throw new BusinessException("创建任务失败，非法的初始化参数数据[EXCEL_DOWNLOAD_URL]");
        }
    }

    /**
     * When an object implementing interface <code>Runnable</code> is used
     * to create a thread, starting the thread causes the object's
     * <code>run</code> method to be called in that separately executing
     * thread.
     * <p>
     * The general contract of the method <code>run</code> is that it may
     * take any action whatsoever.
     *
     * @see Thread#run()
     */
    @Override
    public void run() {

        try {
            UserUtils.setToken(this.exportContext.getLoginUserToken());
            this.exportContext.setTaskBeginTime(LocalDateTime.now());
            //执行保存excel到下载中心
            this.exportHelper.saveExcelFile(this.exportContext);
            String msg = "创建导出任务 [" + exportContext.getTaskCode() + "] -> 开始执行...";
            log.warn(msg);
            this.exportHelper.sendWebsocketMsgMQ(msg, exportContext);
            //返回上传文件
            UploadVo uploadVo = this.excelExportUtil.repeatedWrite(exportContext);
            this.exportContext.setUploadVo(uploadVo);
            this.exportContext.setTaskEndTime(LocalDateTime.now());
            //更新excel文件到下载中心
            this.exportHelper.updateExcelFile(this.exportContext, true);
            this.exportHelper.sendWebsocketMsgMQ("上传完成：<a href=" + EXCEL_DOWNLOAD_URL + "?objectName=" + uploadVo.getObjectName() + ">点击下载</a>", exportContext);

//            this.exportHelper.sendWebsocketMsgMQ("更新excel文件到下载中心失败", exportContext);
        } catch (BusinessException  e) {
            log.error("导出任务 [" + exportContext.getTaskCode() + "]导出文件失败:" + e.getMsg(), e);
            this.exportHelper.sendWebsocketMsgMQ(e.getMsg(), exportContext);
        }catch (Exception e){
            log.error("导出任务 [" + exportContext.getTaskCode() + "]导出文件失败:" + e.getMessage(), e);
            this.exportHelper.sendWebsocketMsgMQ("导出excel文件失败.....", exportContext);
        }
    }

}
