package com.biz.crm.excel.util;

import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 16:23
 * @description
 */
public class ImportVoCheckUtil {

    public static boolean isNotNull(AbstractImportVo importVo, Object propertyValue, String propertyName){
        if(propertyValue == null){
            importVo.appendErrorValidateMsg(propertyName + "不能为空;");
            return false;
        }
        if(propertyValue instanceof String && StringUtils.isBlank(propertyValue.toString())){
            importVo.appendErrorValidateMsg(propertyName + "不能为空;");
            return false;
        }
        return true;
    }


    public static void checkNotNull(AbstractImportVo importVo, Object propertyValue, String propertyName){
        if(propertyValue == null){
            importVo.appendErrorValidateMsg(propertyName + "不能为空;");
            return;
        }
        if(propertyValue instanceof String && StringUtils.isBlank(propertyValue.toString())){
            importVo.appendErrorValidateMsg(propertyName + "不能为空;");
        }
    }

    public static void checkIsNull(AbstractImportVo importVo, Object propertyValue, String propertyName, String tips){
        if(propertyValue == null){
            importVo.appendErrorValidateMsg(tips + "不应包含"+ propertyName + "字段;");
            return;
        }
        if(propertyValue instanceof String && StringUtils.isBlank(propertyValue.toString())){
            importVo.appendErrorValidateMsg(tips + "不应包含"+ propertyName + "字段;");
        }
    }

    public static void check(AbstractImportVo importVo, Object propertyValue, String propertyName, String tips){
        if(tips == null){
            checkNotNull(importVo, propertyValue, propertyName);
        }else {
            checkIsNull(importVo, propertyValue, propertyName, tips);
        }
    }

    public static String getAndCheckDict(AbstractImportVo importVo, String propertyValue, String propertyName, String dictTypeCode){
        String code = null;
        if(isNotNull(importVo, propertyValue, propertyName)){
            if ((code = DictUtil.getFirstCodeByValue(dictTypeCode,  propertyValue)) == null){
                importVo.appendErrorValidateMsg("字典中未找到该" + propertyName + ";");
                return null;
            }
        }
        return code;
    }

    public static void checkValidAmount(AbstractImportVo importVo, BigDecimal propertyValue, String propertyName){
        if(propertyValue == null){
            importVo.appendErrorValidateMsg(propertyName + "不能为空;");
            return;
        }
        if(propertyValue.compareTo(BigDecimal.ZERO) < 0){
            importVo.appendErrorValidateMsg(propertyName + "不应小于0");
        }
    }
}
