package com.biz.crm.excel.vo.kms.acceptanceform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author maoshen
 * @date 2021/6/10.
 */
@Data
public class KmsAcceptanceFormImportVo extends AbstractImportVo {

    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String id;

    @ExcelIgnore
    private String tenantryId;


    @ExcelIgnore
    private String rawDataId;


    @ExcelIgnore
    private String orderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*商超名称(例:永辉)")
    private String kaName;

    @ColumnWidth(30)
    @ExcelProperty("*商超验收单号(例:GR21071300406)")
    private String kaOrderNumber;

    @ExcelIgnore
    private String invoicesSource;

    @ExcelIgnore
    private String kaCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店编码(例:9538)")
    private String kaStoreCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店名称(例:万景国际店)")
    private String kaStoreName;


    @ColumnWidth(30)
    @ExcelProperty("*验收日期(20210715)")
    private String acceptanceDate;


    @ExcelIgnore
    private String areaCode;

    @ExcelIgnore
    private String areaName;


    @ColumnWidth(30)
    @ExcelProperty("*商超产品编号(例:1240679)")
    private String kaGoodsCode;

    @ColumnWidth(30)
    @ExcelProperty("商超产品名称(例:鲜牛奶750ml)")
    private String kaGoodsName;


    @ColumnWidth(30)
    @ExcelProperty("*产品规格")
    private String specification;

    @ColumnWidth(30)
    @ExcelProperty("*验收数量")
    private String curUnitAcceptanceQuantity;

    @ExcelProperty("*验收单价（含税）")
    @ColumnWidth(30)
    private String acceptanceAmount;

    @ExcelIgnore
    private String taxRate;

    @ColumnWidth(30)
    @ExcelProperty("*验收总金额（含税）")
    private String finalAcceptanceAmount;

    @ExcelIgnore
    private String finalAcceptanceAmountNot;

    @ExcelIgnore
    private String transStatus;
}
