package com.biz.crm.excel.vo.kms.acceptanceform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2021年10月13日 11:16:00
 */

@Data
public class KmsAcceptanceFormSimpleImportVo extends AbstractImportVo {

    /**
     * 租户id
     */
    @ExcelIgnore
    private String tenantryId;

    /**
     * 直营体系Id
     */
    @ExcelIgnore
    private String bsDirectSystemId;

    /**
     * 直营体系编码
     */
    @ExcelIgnore
    private String kaCode;

    /**
     * 直营体系名称
     */
    @ColumnWidth(30)
    @ExcelProperty("*直营体系名称")
    private String kaName;

    /**
     * CRM终端编码
     */
    @ColumnWidth(30)
    @ExcelProperty("*CRM终端编码")
    private String storeCode;

    /**
     * CRM终端名称
     */
    @ColumnWidth(30)
    @ExcelProperty("CRM终端名称")
    private String storeName;

    /**
     * 商超验收单编码
     */
    @ColumnWidth(30)
    @ExcelProperty("*商超验收单编码")
    private String kaOrderNumber;

    /**
     * 验收日期
     */
    @ColumnWidth(30)
    @ExcelProperty("*验收日期(yyyyMMdd)")
    private String acceptanceDate;

    /**
     * 备注
     */
    @ColumnWidth(30)
    @ExcelProperty("备注")
    private String remarks;

    /**
     * CRM产品编码
     */
    @ColumnWidth(30)
    @ExcelProperty("*CMR产品编码")
    private String goodsCode;

    /**
     * CRM产品编码
     */
    @ColumnWidth(30)
    @ExcelProperty("CMR产品名称")
    private String goodsName;

    /**
     * 本次验收数量
     */
    @ColumnWidth(30)
    @ExcelProperty("*本次验收数量")
    private String curUnitAcceptanceQuantity;

    /**
     * 本次验收单价
     */
    @ColumnWidth(30)
    @ExcelProperty("本次验收单价")
    private String acceptanceAmount;

    /**
     * 本次验收金额
     */
    @ColumnWidth(30)
    @ExcelProperty("*本次验收金额")
    private String finalAcceptanceAmount;

    /**
     * 转换辨识
     */
    @ExcelIgnore
    private String transStatus;

//
//    @ApiModelProperty("验收单商品")
//    @TableField(exist = false)
//    private List<KmsAcceptanceGoodsEntity> kmsAcceptanceGoodsEntityList;
}
