package com.biz.crm.excel.vo.kms.kaproduct;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author maoshen
 * @date 2021/5/24.
 */
@Data
public class KmsTenantryDirectProductImportVo extends AbstractImportVo {

    @ExcelIgnore
    private String Id;

    @ExcelIgnore
    private String bsDirectSystemId;

    @ColumnWidth(20)
    @ExcelProperty(value = "*直营体系编码(例:CR-0001)")
    private String bsDirectSystemCode;

    @ExcelIgnore
    private String bsDirectSystemName;

    /**
     * 客户分类编码
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "*客户分类编码(例:300002029)")
    private String sellPartyCode;

    /**
     * 售达方名称
     */
    @ExcelIgnore
    @ExcelProperty(value = "客户分类名称(例:300002029)")
    private String sellPartyName;

    /**
     * CRM产品编码
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "*CRM产品编码(例:50004439)")
    private String productCode;

    /**
     * CRM产品编码名称
     */
    @ExcelIgnore
    @ExcelProperty(value = "CRM产品名称(例:老酸奶)")
    private String productName;

    @ColumnWidth(20)
    @ExcelProperty(value = "*商超产品编码(例:1032631)")
    private String kaProductCode;

    @ColumnWidth(20)
    @ExcelProperty(value = "*商超产品名称(例:酸酸奶)")
    private String kaProductName;

    /**
     * 是否默认产品（Y/N)
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "*是否默认产品(例:Y)")
    private String isDefault;

    /**
     * 是否默认直营产品
     */
    @ColumnWidth(20)
    @ExcelIgnore
    private String isDirect;


    @ColumnWidth(20)
    @ExcelIgnore
    private Integer timeOfWeek;

    @ColumnWidth(20)
    @ExcelProperty(value = "*单据类型 (例:ACCEPTANCE)")
    private String orderType;

    @ColumnWidth(20)
    @ExcelProperty(value = "*CRM产品单位编码 (例:EA)")
    private String unitCode;

    @ColumnWidth(20)
    @ExcelProperty(value = "*CRM产品单位名称 (例:EA)")
    private String unitName;

    @ColumnWidth(20)
    @ExcelProperty(value = "*CRM单位数量 (例:1)")
    private BigDecimal numerator;

    @ColumnWidth(20)
    @ExcelProperty(value = "*商超产品单位名称 (例:NULLX)")
    private String kaUnitCode;

    @ColumnWidth(20)
    @ExcelProperty(value = "*商超单位数量 (例:1)")
    private BigDecimal ratio;


    @ExcelIgnore
    private String directId;
}
