package com.biz.crm.excel.vo.kms.orderform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author maoshen
 * @date 2021/6/10.
 */
@Data
public class KmsOrderFormImportVo extends AbstractImportVo {

    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String id;

    @ExcelIgnore
    private String tenantryId;


    @ExcelIgnore
    private String rawDataId;


    @ExcelIgnore
    private String orderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*商超名称(例:永辉)")
    private String kaName;

    @ColumnWidth(30)
    @ExcelProperty("*商超订货单号(例:4066007989)")
    private String kaOrderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*订单版本号(例:1)")
    private String versionNumber;

    @ExcelIgnore
    private String invoicesSource;

    @ExcelIgnore
    private String kaCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店编码(例:9538)")
    private String kaStoreCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店名称(例:万景国际店)")
    private String kaStoreName;


    @ColumnWidth(30)
    @ExcelProperty("*订货日期(例:20210715)")
    private String orderDate;

    @ColumnWidth(30)
    @ExcelProperty("送货日期(例:20210716)")
    private String deliveryDate;

    @ExcelIgnore
    private String areaCode;

    @ExcelIgnore
    private String areaName;


    @ColumnWidth(30)
    @ExcelProperty("*商超产品编号(例:1240679)")
    private String kaGoodsCode;

    @ColumnWidth(30)
    @ExcelProperty("商超产品名称(例:鲜牛奶750ml)")
    private String kaGoodsName;

    @ColumnWidth(30)
    @ExcelProperty("产品规格")
    private String specification;

    @ExcelProperty("*订货单价（含税）")
    @ColumnWidth(30)
    private String unitPrice;

    @ExcelProperty("*订单总额（含税）")
    @ColumnWidth(30)
    private String orderAmount;

    @ExcelProperty("*商超单位")
    @ColumnWidth(30)
    private String curUnit;

    @ExcelProperty("*订货数量")
    @ColumnWidth(30)
    private String curUnitOrderQuantity;

    @ExcelIgnore
    private String transStatus;
}
