package com.biz.crm.excel.vo.kms.orderform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author : DuYiRan
 * @date : 2021/10/22
 */

@Data
public class KmsOrderFormSimpleImportVo extends AbstractImportVo{

    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String id;

    @ExcelIgnore
    private String tenantryId;

    @ExcelIgnore
    private String rawDataId;

    @ExcelIgnore
    private String orderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*直营体系名称")
    private String kaName;

    @ExcelIgnore
    private String versionNumber;

    @ExcelIgnore
    private String invoicesSource;

    @ExcelIgnore
    private String kaCode;

    @ExcelIgnore
    private String kaStoreCode;

    @ExcelIgnore
    private String kaStoreName;

    @ColumnWidth(32)
    @ExcelProperty("*CRM终端编码")
    private String storeCode;

    @ColumnWidth(128)
    @ExcelProperty("CRM终端名称")
    private String storeName;

    @ColumnWidth(64)
    @ExcelProperty("*商超订单编码")
    private String kaOrderNumber;

    @ColumnWidth(10)
    @ExcelProperty("*订货日期(例:2021-07-15)")
    private String orderDate;

    @ColumnWidth(10)
    @ExcelProperty("*订单到货日期(例:2021-07-16)")
    private String deliveryDate;

    @ExcelIgnore
    private String areaCode;

    @ExcelIgnore
    private String areaName;

    @ExcelIgnore
    private String customerCode;

    @ExcelIgnore
    private String customerName;

    @ExcelIgnore
    private String orgCode;

    @ExcelIgnore
    private String orgName;

    @ColumnWidth(30)
    @ExcelProperty("*CRM产品编号")
    private String goodsCode;

    @ColumnWidth(30)
    @ExcelProperty("CRM产品名称")
    private String goodsName;

    @ExcelIgnore
    private String specification;

    @ExcelIgnore
    private String unitPrice;

    @ExcelIgnore
    private String orderAmount;

    @ExcelIgnore
    private String curUnit;

    @ExcelProperty("*数量")
    @ColumnWidth(30)
    private String curUnitOrderQuantity;

    @ExcelIgnore
    private String transStatus;

}
