package com.biz.crm.excel.vo.kms.returnform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author maoshen
 * @date 2021/8/27.
 */
@Data
public class KmsReturnFormImportVo extends AbstractImportVo {

    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String id;

    @ExcelIgnore
    private String tenantryId;


    @ExcelIgnore
    private String rawDataId;


    @ExcelIgnore
    private String orderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*商超名称(例:永辉)")
    private String kaName;

    @ColumnWidth(30)
    @ExcelProperty("*商超退货单编号(例:4066007989)")
    private String kaOrderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*退货版本号(例:1)")
    private String versionNumber;

    @ExcelIgnore
    private String invoicesSource;

    @ExcelIgnore
    private String kaCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店编码(例:9538)")
    private String kaStoreCode;

    @ColumnWidth(30)
    @ExcelProperty("*商超门店名称(例:万景国际店)")
    private String kaStoreName;


    @ColumnWidth(30)
    @ExcelProperty("*退货单日期(例:20210715)")
    private String orderDate;

    @ColumnWidth(30)
    @ExcelProperty("*退货订单总额(含税)")
    private String finalReturnAmount;

    @ExcelIgnore
    private String areaCode;

    @ExcelIgnore
    private String areaName;


    @ColumnWidth(30)
    @ExcelProperty("*商超产品编号(例:1240679)")
    private String kaGoodsCode;

    @ColumnWidth(30)
    @ExcelProperty("商超产品名称(例:鲜牛奶750ml)")
    private String kaGoodsName;

    @ColumnWidth(30)
    @ExcelProperty("*产品规格(例:195g)")
    private String specification;

    @ExcelProperty("*退货单价（含税）")
    @ColumnWidth(30)
    private String unitPrice;

    @ExcelIgnore
    private String returnAmount;

    @ExcelProperty("*商超单位")
    @ColumnWidth(30)
    private String curUnit;

    @ExcelProperty("*退货数量")
    @ColumnWidth(30)
    private String curUnitOrderQuantity;

    @ExcelIgnore
    private String transStatus;
}
