package com.biz.crm.excel.vo.kms.returnform;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2021年10月18日 15:22:00
 */
@Data
public class KmsReturnFormSimpleImportVo extends AbstractImportVo {
    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String id;

    @ExcelIgnore
    private String tenantryId;


    @ExcelIgnore
    private String rawDataId;


    @ExcelIgnore
    private String orderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*直营体系名称")
    private String kaName;

    @ExcelIgnore
    private String kaCode;

    @ColumnWidth(30)
    @ExcelProperty("*CRM终端编码")
    private String storeCode;

    @ColumnWidth(30)
    @ExcelProperty("*CRM终端名称")
    private String storeName;

    @ColumnWidth(30)
    @ExcelProperty("*商超退货单编号")
    private String kaOrderNumber;

    @ColumnWidth(30)
    @ExcelProperty("*退货日期")
    private String orderDate;

    @ColumnWidth(30)
    @ExcelProperty("退货备注")
    private String remarks;

    @ColumnWidth(30)
    @ExcelProperty("*CRM产品编号")
    private String goodsCode;

    @ColumnWidth(30)
    @ExcelProperty("CRM产品名称")
    private String goodsName;


    @ExcelProperty("*退货数量")
    @ColumnWidth(30)
    private String curUnitOrderQuantity;

    @ExcelProperty("退货单价（含税）")
    @ColumnWidth(30)
    private String unitPrice;

    @ColumnWidth(30)
    @ExcelProperty("*退货订单总额(含税)")
    private String finalReturnAmount;

    @ExcelIgnore
    private String versionNumber;

    @ExcelIgnore
    private String invoicesSource;


    @ExcelIgnore
    private String kaStoreCode;

    @ExcelIgnore
    private String kaStoreName;


    @ExcelIgnore
    private String areaCode;

    @ExcelIgnore
    private String areaName;


    @ExcelIgnore
    private String returnAmount;

    @ExcelIgnore
    private String transStatus;
}
