package com.biz.crm.excel.vo.kms.tenantrydirectstore;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
@Data
public class KmsTenantryDirectStoreImportVo extends AbstractImportVo {
    @ColumnWidth(20)
    @ExcelProperty(value = "*直营体系编码(例:CR-0001)")
    private String bsDirectSystemCode;

    @ColumnWidth(20)
    @ExcelProperty(value = "*维度")
    private String dimension;

    @ColumnWidth(20)
    @ExcelProperty(value = "*商超门店编码(例:9538)")
    private String storeCode;

    @ExcelIgnore
    private String storeName;

    @ExcelIgnore
    private String storeId;

    @ColumnWidth(20)
    @ExcelProperty(value = "门店区域 (例:1)")
    private String areaCode;

    @ExcelIgnore
    private String areaId;

    @ColumnWidth(20)
    @ExcelProperty(value = "*CRM终端编码(例:300016784)")
    private String terminalCode;

    @ExcelIgnore
    private String terminalName;

    @ExcelIgnore
    private String bsDirectSystemName;

    @ExcelIgnore
    private String bsDirectSystemId;

    @ApiModelProperty("企业产品Id")
    @ExcelIgnore
    private String productId;

    @ColumnWidth(20)
    @ExcelProperty(value = "CRM产品编码(例:282126085)")
    @ApiModelProperty("企业产品编码")
    private String productCode;

    @ApiModelProperty("企业产品名称")
    @ExcelIgnore
    private String productName;

    @ColumnWidth(20)
    @ExcelProperty(value = "供应商(例:282126085)")
    private String supplierCode;


    @ColumnWidth(20)
    @ExcelProperty(value = "对账匹配阈值（天数）")
    private Integer timeOfDay;

    @ExcelIgnore
    private String directId;

}
