package com.biz.crm.excel.vo.kms.totalwarehouse;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * @author maoshen
 * @date 2021/6/28.
 */
@Data
public class KmsTotalWareHouseStoreImportVo extends AbstractImportVo {

    @ColumnWidth(20)
    @ExcelProperty("*直营体系编码 (例:CR-0001)")
    private String bsDirectSystemCode;

    @ExcelIgnore
    private String bsDirectSystemId;

    @ExcelIgnore
    private String bsDirectSystemName;

    @ExcelIgnore
    private String productType;

    @ExcelProperty("*产品类型（例:常温）")
    @ColumnWidth(20)
    private String productTypeDesc;

    @ExcelIgnore
    private String directStoreId;

    @ExcelProperty("*送达方编码）")
    @ColumnWidth(20)
    private String terminalCode;

    @ExcelIgnore
    private String terminalName;

    @ExcelIgnore
    private String kaProductCode;

    @ColumnWidth(30)
    @ExcelProperty("企业产品编码")
    private String productCode;

    @ExcelIgnore
    private String productName;

    @ExcelIgnore
    private String directProductId;

    @ExcelIgnore
    private String directId;
}
