package com.biz.crm.excel.vo.mdm.availablelistrule;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

/**
 * 可购规则导入vo
 * @Author: chenrong
 * @Date: 2021/3/18 10:06
 */
@Data
public class AvailableRuleImportVo extends AbstractImportVo {

  /*** 基础信息 ***/
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则编码")
  private String code;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则名称")
  private String name;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则类型，1：可购，0：不可购")
  private Integer type;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则维度，客户组织：0，客户：1，终端组织：2，终端：3")
  private Integer dimension;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则来源编码")
  private String source;

  @ColumnWidth(value = 20)
  @ExcelProperty(value = "可购规则来源记录id")
  private String sourceId;


  /*** 可购范围 ***/
  /**
   * 组织编码(包含客户和终端)(仅仅是保存前段显示用,瞬时数据)
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "组织编码")
  private String orgCode;

  /**
   * 组织名称(包含客户和终端)(仅仅是保存前段显示用,瞬时数据)
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "组织名称")
  private String orgName;

  /**
   * 客户编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户编码")
  private String cusCode;

  /**
   * 客户名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户名称")
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户组织编码")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户组织名称")
  private String cusOrgName;

  /**
   * 客户所属渠道编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属渠道编码")
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "客户所属渠道名称")
  private String cusChannelName;


  /**
   * 终端编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端名称")
  private String terminalName;

  /**
   * 终端所属组织编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端所属组织编码")
  private String terminalOrgCode;

  /**
   * 终端所属组织名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端所属组织名称")
  private String terminalOrgName;

  /**
   * 终端所属渠道编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端所属渠道编码")
  private String terminalChannelCode;

  /**
   * 终端所属渠道名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "终端所属渠道名称")
  private String terminalChannelName;


  /*** 可购商品 ***/
  /**
   * 商品编码
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品编码")
  private String goodsCode;

  /**
   * 商品名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品名称")
  private String goodsName;

  /**
   * 商品规格
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品规格")
  private String productSpec;

  /**
   * 产品层级code
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品层级编码")
  private String productLevelCode;

  /**
   * 产品层级名称
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "商品层级名称")
  private String productLevelName;

  /**
   * 是否是产品层级(数据字典)
   */
  @ColumnWidth(value = 20)
  @ExcelProperty(value = "是否产品层级（Y是，N否）")
  private String productLevelFlag;
}
