package com.biz.crm.excel.vo.mdm.customer;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.sqlupdate.CrmColumn;
import io.swagger.annotations.ApiModelProperty;
import jdk.nashorn.internal.ir.annotations.Ignore;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户信息
 *
 * @author zxw
 * @date 2020-12-30 18:05
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmCustomerImportVo extends AbstractImportVo {

    @ExcelProperty("客户编码")
    @ColumnWidth(20)
    private String customerCode;

    @ExcelProperty("客户名称")
    @ColumnWidth(20)
    private String customerName;

    @ExcelProperty("渠道名称")
    private String channelName;

    @ExcelIgnore
    private String channel;

    @ExcelProperty("客户组织编码")
    @ColumnWidth(30)
    private String customerOrgCode;

    @ExcelProperty("客户类型")
    @ColumnWidth(20)
    private String customerTypeName;
    @ExcelIgnore
    private String customerType;

    @ExcelProperty("组织编码")
    @ColumnWidth(20)
    private String orgCode;

    @ExcelIgnore
    private String provinceCode;

    @ExcelIgnore
    private String cityCode;

    @ExcelIgnore
    private String districtCode;

    @ExcelProperty("省")
    @ColumnWidth(20)
    private String provinceName;

    @ExcelProperty("市")
    @ColumnWidth(20)
    private String cityName;

    @ExcelProperty("区")
    @ColumnWidth(20)
    private String districtName;

    @ExcelProperty("注册地址")
    @ColumnWidth(20)
    private String registeredAddress;

    @ExcelProperty("客户联系方式")
    @ColumnWidth(30)
    private String customerContact;

    @ExcelProperty("客户法人代表")
    @ColumnWidth(30)
    private String legalRepresentative;

    @ExcelProperty("经度")
    private String longitude;
    @ExcelProperty("纬度")
    private String latitude;
    @ExcelProperty("联系人名称")
    @ColumnWidth(30)
    private String contactName;
    @ExcelProperty("联系人电话")
    @ColumnWidth(30)
    private String contactPhone;

}
