package com.biz.crm.excel.vo.mdm.function;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.sqlupdate.CrmColumn;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author zxw
 * @date 2021-04-13 10:04
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmDataPermissionImportVo extends AbstractImportVo {

    @ExcelProperty("角色编码")
    @ColumnWidth(40)
    private String roleCode;

    @ExcelProperty("菜单编码")
    @ColumnWidth(40)
    private String functionCode;

    @ExcelProperty("功能列表编码")
    @ColumnWidth(40)
    private String listConfigCode;

    @ExcelIgnore
    @ColumnWidth(40)
    private String permissionObjCode;

    /**
     * 查询对象编码
     */
    @ExcelProperty("查询对象")
    @ColumnWidth(40)
    private String permissionObjName;

    @ExcelIgnore
    @ColumnWidth(40)
    private String orgCode;

    @ExcelIgnore
    @ColumnWidth(40)
    private String positionCode;

    /**
     * 数据来源，数据字典：permission_resource
     */
    @ExcelIgnore
    @ColumnWidth(40)
    private String permissionResource;

    /**
     * 数据来源，数据字典：permission_resource
     */
    @ExcelIgnore
    @ColumnWidth(40)
    private String permissionResourceName;


    @ExcelIgnore
    @ColumnWidth(40)
    private String permissionSearchType;
    /**
     * 查询方式
     */
    @ExcelProperty("查询方式")
    @ColumnWidth(40)
    private String permissionSearchTypeName;
}
