package com.biz.crm.excel.vo.mdm.material;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Author hej
 * @Created Date 2020-12-31 15:12
 * 物料导入
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmMaterialImportVo extends AbstractImportVo {

    /**
     * 物料编码
     */
    @ExcelProperty("物料编码")
    @ColumnWidth(20)
    private String materialCode;

    @ExcelProperty("物料名称")
    @ColumnWidth(20)
    private String materialName;

    /**
     * 产品层级编码
     */
    @ExcelProperty("产品层级编码")
    @ColumnWidth(20)
    private String productLevelCode;

    /**
     * 物料类型
     */
    @ExcelProperty("物料类型")
    @ColumnWidth(20)
    private String materialTypeName;
    @ExcelIgnore
    private String materialType;

    /**
     * 规格
     */
    @ExcelProperty("规格")
    @ColumnWidth(20)
    private String specification;

    /**
     * 销售公司
     */
    @ExcelProperty("销售公司")
    @ColumnWidth(20)
    private String saleCompanyName;
    @ExcelIgnore
    private String saleCompany;

    /**
     * 基本单位
     */
    @ExcelProperty("基本单位")
    @ColumnWidth(20)
    private String baseUnitName;
    @ExcelIgnore
    private String baseUnit;

    /**
     * 销售单位
     */
    @ExcelProperty("销售单位")
    @ColumnWidth(20)
    private String saleUnitName;
    @ExcelIgnore
    private String saleUnit;

    /**
     * 成本价格
     */
    @ExcelProperty("成本价(元)")
    @ColumnWidth(20)
    private String costPrice;

    /**
     * 单位换算系数
     */
    @ExcelProperty("单位换算系数")
    @ColumnWidth(20)
    private String unitConversion;

    /**
     * 条形码
     */
    @ExcelProperty("条形码")
    @ColumnWidth(20)
    private String barCode;    /**
     * 产品名称
     */

    /**
     * ai编码
     */
    @ExcelProperty("AI编码")
    @ColumnWidth(20)
    private String aiCode;


    /**
     * 毛重
     */
    @ExcelProperty("毛重")
    @ColumnWidth(20)
    private String grossWeight;

    /**
     * 净重
     */
    @ExcelProperty("净重")
    @ColumnWidth(20)
    private String netWeight;

    /**
     * 容量
     */
    @ExcelProperty("容量")
    @ColumnWidth(20)
    private String capacity;


    /**
     * 标准单位
     */
    @ExcelProperty("标准单位(标盒,标箱)")
    @ColumnWidth(20)
    private String standardUnitName;
    @ExcelIgnore
    private String standardUnit;

    /**
     * 盒码单位换算系数
     */
    @ExcelProperty("盒码单位换算系数")
    @ColumnWidth(20)
    private String boxUnitConversion;

    /**
     * 箱码单位换算系数
     */
    @ExcelProperty("箱码单位换算系数")
    @ColumnWidth(20)
    private String caseUnitConversion;
}
