package com.biz.crm.excel.vo.mdm.materialGroup;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Author yangf
 * @Created Date 2021-08-25 15:12
 * 物料导入
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmMaterialGroupImportVo extends AbstractImportVo {

    /**
     * 物料组编码
     */
    @ExcelProperty("物料组编码")
    @ColumnWidth(20)
    private String materialGroupCode;

    @ExcelProperty("物料组名称")
    @ColumnWidth(20)
    private String materialGroupName;

    @ExcelProperty("物料组描述")
    @ColumnWidth(20)
    private String description;

    @ExcelProperty("物料编码(多个以逗号隔开)")
    @ColumnWidth(20)
    private String materialCode;

}
