package com.biz.crm.excel.vo.mdm.org;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 组织导入vo
 *
 * @author zxw
 * @date 2020-12-29 11:44
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmOrgImportVo extends AbstractImportVo {

    @ColumnWidth(20)
    @ExcelProperty("组织编码")
    private String orgCode;

    @ColumnWidth(20)
    @ExcelProperty("组织名称")
    private String orgName;

    /**
     * mdm_org_type对应的中文值
     */
    @ColumnWidth(20)
    @ExcelProperty("组织层级")
    private String orgTypeName;

    @ColumnWidth(20)
    @ExcelProperty("上级组织编码")
    private String parentCode;

    /**
     * mdm_org_type对应的编码
     */
    @ExcelIgnore
    private String orgType;
}
