package com.biz.crm.excel.vo.mdm.position;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = true)
public class MdmPositionImportVo extends AbstractImportVo {

    @ColumnWidth(20)
    @ExcelProperty("职位编码")
    private String positionCode;

    @ColumnWidth(20)
    @ExcelProperty("职位名称")
    private String positionName;

    @ColumnWidth(20)
    @ExcelProperty("职位级别编码")
    private String positionLevelCode;

    @ColumnWidth(20)
    @ExcelProperty("所属组织编码")
    private String orgCode;

    @ColumnWidth(20)
    @ExcelProperty("上级职位编码")
    private String parentCode;

    @ColumnWidth(50)
    @ExcelProperty("权限角色编码（不填则取职位级别的角色，填写则取填写的角色，多个用英文逗号隔开）")
    private String roleCode;

    @ColumnWidth(50)
    @ExcelProperty("流程角色编码（多个用英文逗号隔开）")
    private String bpmRoleCode;


}
