package com.biz.crm.excel.vo.mdm.price;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格导入vo
 *
 * @author zxw
 * @date 2021-01-25 14:30
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmPriceSettingImportVo  extends AbstractImportVo {

    @ColumnWidth(40)
    @ExcelProperty(value = "条件字段分类编码")
    private String conditionGroupCode;

    @ColumnWidth(40)
    @ExcelProperty(value = "条件类型编码")
    private String conditionTypeCode;

    @ColumnWidth(40)
    @ExcelProperty(value = "客户编码")
    private String customerCode;

    @ColumnWidth(40)
    @ExcelProperty(value = "渠道名称")
    private String channel;

    @ColumnWidth(40)
    @ExcelProperty(value = "组织编码")
    private String orgCode;

    @ColumnWidth(40)
    @ExcelProperty(value = "商品编码")
    private String productCode;

    @ColumnWidth(40)
    @ExcelProperty(value = "价格")
    private String price;

    @ColumnWidth(40)
    @ExcelProperty(value = "币种")
    private String currencyType;

    @ColumnWidth(40)
    @ExcelProperty(value = "价格单位")
    private String priceUnit;

    @ColumnWidth(40)
    @ExcelProperty(value = "单位类型")
    private String unitType;

    @ColumnWidth(40)
    @ExcelProperty(value = "有效开始时间")
    private String beginDate;

    @ColumnWidth(40)
    @ExcelProperty(value = "有效结束时间")
    private String endDate;

    @ColumnWidth(40)
    @ExcelProperty(value = "价格组")
    private String priceGroup;

    @ColumnWidth(40)
    @ExcelProperty(value = "终端编码")
    private String terminalCode;


}
