package com.biz.crm.excel.vo.mdm.product;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 商品导入
 *
 * @author hej
 * @date 2020-12-30 15:38
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmProductImportVo extends AbstractImportVo {

    /**
     * 组织编码
     */
    @ColumnWidth(20)
    @ExcelProperty("商品编码")
    private String productCode;

    /**
     * 组织名称
     */
    @ColumnWidth(20)
    @ExcelProperty("商品名称")
    private String productName;
    /**
     * 产品类型
     */
//    @ExcelProperty("产品类型(对应数据字典:product_type[标准商品:standard,礼包商品:gift_package,范围商品:range])")
    @ColumnWidth(20)
    @ExcelProperty("商品类型")
    private String productTypeName;
    @ExcelIgnore
    private String productType;
    /**
     * 组织类型
     */
    @ColumnWidth(20)
    @ExcelProperty("产品层级编码")
    private String productLevelCode;

    /**
     * 上下架状态(数据字典)
     */
    @ExcelProperty("上下架状态")
    @ColumnWidth(50)
    private String isShelfName;
    @ExcelIgnore
    private String isShelf;

    /**
     * 开始日期
     */
    @ExcelProperty("开始时间(yyyy-MM-dd)")
    @ColumnWidth(20)
    private String beginDate;

    /**
     * 结束日期
     */
    @ExcelProperty("结束时间(yyyy-MM-dd)")
    @ColumnWidth(20)
    private String endDate;



    /**
     * 规格
     */
    @ColumnWidth(20)
    @ExcelProperty("规格")
    private String spec;

    /**
     * 销售单位
     */
//    @ExcelProperty("销售单位(对应数据字典:product_sale_unit[箱:bag,盒:box,瓶:bottle])")
    @ColumnWidth(20)
    @ExcelProperty("销售单位")
    private String saleUnitName;
    @ExcelIgnore
    private String saleUnit;


    /**
     * 基本单位
     */
    @ExcelProperty("基本单位")
    @ColumnWidth(20)
    private String baseUnitName;
    @ExcelIgnore
    private String baseUnit;

    /**
     * 条形码
     */
//    @ExcelProperty("条形码")
//    @ColumnWidth(20)
//    private String barCode;

    /**
     * 商品介绍
     */
//    @ExcelProperty("商品介绍")
//    @ColumnWidth(20)
//    private String introduction;



    /**
     * 物料编码
     */
    @ExcelProperty("物料编码")
    @ColumnWidth(20)
    private String materialCode;

    /**
     * 物料数量
     */
    @ExcelProperty("数量")
    @ColumnWidth(20)
    private String count;

    /**
     * 物料名称
     */
//    @ExcelProperty("物料名称")
//    @ColumnWidth(20)
//    private String materialName;

    /**
     * 比例
     */
//    @ExcelProperty("比例")
//    @ColumnWidth(20)
//    private BigDecimal ratio;



}
