package com.biz.crm.excel.vo.mdm.product;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导入
 * @Author hej
 * @Created Date 2021-01-04 11:31
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmProductLevelImportVo extends AbstractImportVo {

    /**
     * 产品层级编码
     */
    @ExcelProperty("产品层级编码")
    @ColumnWidth(20)
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @ExcelProperty("产品层级名称")
    @ColumnWidth(20)
    private String productLevelName;

    /**
     * 产品层级类型 品牌:brand,系列:series,大类:max,细类:min
     */
    @ExcelProperty("产品层级类型")
    @ColumnWidth(20)
    private String productLevelTypeName;
    @ExcelIgnore
    private String productLevelType;


    /**
     * 上级编码
     */
    @ExcelProperty("上级产品层级编码")
    @ColumnWidth(30)
    private String parentCode;

    @ExcelProperty("备注")
    @ColumnWidth(20)
    private String remarks;

}
