package com.biz.crm.excel.vo.mdm.terminal;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 终端信息
 *
 * @author zxw
 * @date 2020-12-30 18:05
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class MdmTerminalImportVo extends AbstractImportVo {


    /**
     * 终端编码
     */
    @ExcelProperty("终端编码")
    @ColumnWidth(20)
    private String terminalCode;
    /**
     * 终端名称
     */
    @ExcelProperty("终端名称")
    @ColumnWidth(20)
    private String terminalName;

    /**
     * 终端类型
     */
    @ExcelProperty("终端类型")
    @ColumnWidth(20)
    private String terminalType;

    /**
     * 所属组织编码
     */
    @ExcelProperty("组织编码")
    @ColumnWidth(20)
    private String orgCode;

    /**
     * 客户组织编码
     */
    @ExcelProperty("客户组织编码")
    @ColumnWidth(30)
    private String customerOrgCode;

    /**
     * 渠道
     */
    @ExcelProperty("渠道")
    private String channel;

    /**
     * 营业执照法人姓名
     */
    @ColumnWidth(30)
    @ExcelProperty("营业执照法人姓名")
    private String licensePersonName;

    /**
     * 营业执照注册号
     */
    @ColumnWidth(30)
    @ExcelProperty("营业执照注册号")
    private String licenseRegisterNumber;

    /**
     * 营业执照企业名称
     */
    @ColumnWidth(30)
    @ExcelProperty("营业执照企业名称")
    private String licenseFirmName;

    /**
     * 终端地址
     */
    @ExcelProperty("终端地址")
    @ColumnWidth(20)
    private String terminalAddress;

    /**
     * 省
     */
    @ExcelProperty("省")
    @ColumnWidth(20)
    private String provinceName;
    @ExcelIgnore
    private String provinceCode;

    /**
     * 市
     */
    @ExcelProperty("市")
    @ColumnWidth(20)
    private String cityName;
    @ExcelIgnore
    private String cityCode;

    /**
     * 区
     */
    @ExcelProperty("区")
    @ColumnWidth(20)
    private String districtName;
    @ExcelIgnore
    private String districtCode;

    /**
     * 经度
     */
    @ExcelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ExcelProperty("纬度")
    private String latitude;


    @ExcelProperty("联系人姓名")
    @ColumnWidth(30)
    private String contactName;
    @ExcelProperty("联系人电话")
    @ColumnWidth(30)
    private String contactPhone;

    @ExcelProperty("kms关联客户门店id")
    @ColumnWidth(40)
    private String storeId;

    @ExcelProperty("kms直营体系id")
    @ColumnWidth(40)
    private String directSystemId;

    @ExcelProperty("kms售达方id")
    @ColumnWidth(40)
    private String sellPartyId;
}
