package com.biz.crm.excel.vo.mdm.user;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

@Data
public class MdmTerminalUserImportVo extends AbstractImportVo {

    @ColumnWidth(30)
    @ExcelProperty(value = "用户名")
    private String fullName;
    @ColumnWidth(30)
    @ExcelProperty(value = "关联终端")
    private String terminalCodeName;
    @ColumnWidth(10)
    @ExcelProperty(value = "性别")
    private String genderName;
    @ColumnWidth(20)
    @ExcelProperty(value = "联系电话")
    private String userPhone;
    @ColumnWidth(20)
    @ExcelProperty(value = "账号")
    private String userName;
    @ColumnWidth(20)
    @ExcelProperty(value = "密码")
    private String userPassword;
    @ColumnWidth(20)
    @ExcelProperty(value = "邮箱")
    private String email;
    @ColumnWidth(20)
    @ExcelProperty(value = "生效时间\n(yyyy-MM-dd)")
    private String startTime;
    @ColumnWidth(20)
    @ExcelProperty(value = "失效时间\n(yyyy-MM-dd)")
    private String endTime;
    @ColumnWidth(20)
    @ExcelProperty(value = "权限角色编码")
    private String roleCode;

    /*** 性别*/
    @ExcelIgnore
    private String gender;
}
