package com.biz.crm.excel.vo.mdm.user;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

@Data
public class MdmUserImportVo extends AbstractImportVo {

    @ColumnWidth(20)
    @ExcelProperty(value = "账号")
    private String userName;
    @ColumnWidth(30)
    @ExcelProperty(value = "用户名")
    private String fullName;
    @ColumnWidth(20)
    @ExcelProperty(value = "邮箱")
    private String email;
    @ColumnWidth(10)
    @ExcelProperty(value = "性别")
    private String genderName;
    @ColumnWidth(20)
    @ExcelProperty(value = "联系电话")
    private String userPhone;
    @ColumnWidth(20)
    @ExcelProperty(value = "密码")
    private String userPassword;
    @ColumnWidth(20)
    @ExcelProperty(value = "生效时间\n(yyyy-MM-dd)")
    private String startTime;
    @ColumnWidth(20)
    @ExcelProperty(value = "失效时间\n(yyyy-MM-dd)")
    private String endTime;
    @ColumnWidth(20)
    @ExcelProperty(value = "操作类型")
    private String operationTypeName;
    @ColumnWidth(20)
    @ExcelProperty(value = "所属组织编码")
    private String orgCode;
    @ColumnWidth(20)
    @ExcelProperty(value = "职位级别编码")
    private String positionLevelCode;
    @ColumnWidth(20)
    @ExcelProperty(value = "上级人员账号")
    private String parentUserName;
    @ColumnWidth(50)
    @ExcelProperty(value = "权限角色编码")
    private String roleCode;
    @ColumnWidth(50)
    @ExcelProperty(value = "流程角色编码")
    private String bpmRoleCode;
    @ColumnWidth(20)
    @ExcelProperty(value = "职位名称")
    private String positionName;

    @ColumnWidth(20)
    @ExcelProperty(value = "主职位编码")
    private String primaryPositionCode;
    @ColumnWidth(50)
    @ExcelProperty(value = "非主职位编码")
    private String otherPositionCodes;

    /*** 性别*/
    @ExcelIgnore
    private String gender;
    /*** 操作类型*/
    @ExcelIgnore
    private String operationType;
    @ExcelIgnore
    private String userCode;

}
