package com.biz.crm.excel.vo.sfa;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 绩效规则
 *
 * @author yangshan
 * @date 2021-2-25 12:56:27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SfaAchievementRuleImportVo extends AbstractImportVo {

    /**
     * 对象编码
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "对象编码", order = 0)
    private String objectCode;

    /**
     * 对象名称
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "对象名称", order = 1)
    private String objectName;

    /**
     * 职位编码
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "职位编码", order = 2)
    private String objectPosCode;
    /**
     * 职位名称
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "职位名称", order = 3)
    private String objectPosName;

    /**
     * 绩效时间
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "绩效时间\n(非必传)", order = 4)
    private String achievementDate;
    /**
     * 绩效时间年份
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "绩效时间年份\n(yyyy)", order = 5)
    private String achievementDateYear;
    /**
     * 绩效时间月份
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "绩效时间月份\n(MM)", order = 6)
    private String achievementDateMonth;
    /**
     * 绩效时间旬度
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "绩效时间旬度\n(上旬/下旬)", order = 7)
    private String achievementDateTenDays;

    /**
     * 开始时间（用于查询记录）
     */
    @ColumnWidth(35)
    @ExcelProperty(value = "开始时间\n(yyyy-MM-dd)\n(类型为自由时间时传值)", order = 8)
    private String beginDate;

    /**
     * 结束时间（用于查询记录）
     */
    @ColumnWidth(35)
    @ExcelProperty(value = "结束时间\n(yyyy-MM-dd)\n(类型为自由时间时传值)", order = 9)
    private String endDate;

    /**
     * 绩效类型
     */
    @ColumnWidth(30)
    @ExcelProperty(value = "绩效类型\n(月度/旬度/自由时间)", order = 10)
    private String achievementType;

    /**
     * 指标编码
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "指标编码", order = 11)
    private String indexCode;

    /**
     * 指标名称
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "指标名称", order = 12)
    private String indexName;

    /**
     * 权重
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "权重", order = 13)
    private String weight = "0";

    /**
     * 目标数量
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "目标数量", order = 14)
    private String targetNum;

    /**
     * 单位
     */
    @ColumnWidth(20)
    @ExcelProperty(value = "单位", order = 15)
    private String unit;
}
