package com.biz.crm.excel.vo.sfa;

import com.biz.crm.nebular.mdm.ExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.elasticsearch.annotations.Mapping;

/**
 * @author yangshan
 * @date 2021/6/15 20:45
 */
@Data
@ApiModel("拜访步骤-库存盘点-库存盘点明细")
public class StockDetailVo extends ExtTenVo{

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("系列编码")
    private String productLevelCode;

    @ApiModelProperty("系列名称")
    private String productLevelName;

    @ApiModelProperty("盘库时间")
    @Mapping(mappingPath = "es-mapping/date-time.json")
    private String stockTime;

    @ApiModelProperty("数量")
    private Integer quantity;

    @ApiModelProperty("单位")
    private String saleUnit;
    /**
     * 单位名称
     */
    @ApiModelProperty("单位名称")
    private String saleUnitName;
}