package com.biz.crm.excel.vo.tpm;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 费用预算导入vo
 *
 * @author yangshan
 * @date 2021-2-23 20:08:17
 */
@Data
public class FeeBudgetImportVo extends AbstractImportVo {

    @ExcelIgnore
    private String feeBudgetType;

//    @ColumnWidth(20)
//    @ExcelProperty("费用预算类型名称")
    @ExcelIgnore
    private String feeBudgetTypeName;

    @ColumnWidth(20)
    @ExcelProperty("预算年份(2021)")
    private String budgetYear;

    /**
     * 季度
     */
    @ExcelIgnore
    private String budgetQuater;

    @ColumnWidth(20)
    @ExcelProperty("预算月份(1-12)")
    private String budgetMonth;

    @ColumnWidth(20)
    @ExcelProperty("专案号")
    private String projectNumber;

    @ColumnWidth(20)
    @ExcelProperty("企业组织编码")
    private String orgCode;

    @ColumnWidth(20)
    @ExcelProperty("企业组织名称")
    private String orgName;

    @ColumnWidth(20)
    @ExcelProperty("预算科目编码")
    private String budgetSubjectsCode;

    @ColumnWidth(20)
    @ExcelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ColumnWidth(20)
    @ExcelProperty("产品层级编码")
    private String productLevelCode;

    @ColumnWidth(20)
    @ExcelProperty("产品层级名称")
    private String productLevelName;

    @ColumnWidth(20)
    @ExcelProperty("产品编码")
    private String productCode;

    @ColumnWidth(20)
    @ExcelProperty("产品名称")
    private String productName;

    @ColumnWidth(20)
    @ExcelProperty("预算金额")
    private String initAmount;

    @ColumnWidth(20)
    @ExcelProperty("备注")
    private String remarks;

}
