package com.biz.crm.excel.vo.tpm.actdetail;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.biz.crm.common.AbstractImportVo;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.excel.vo.MdmPropertyImportVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialUnitRespVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;


/**
 * @author yb
 * @version 1.0
 * @date 2021/12/9 9:53
 * @description
 */
@Data
public class TpmActDetailImportVo extends MdmPropertyImportVo {

    @ExcelProperty("活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @ExcelIgnore
    private String fineName;

    @ExcelProperty("物料编码")
    private String materialCode;
    /**
     * 物料名称
     */
    @ExcelIgnore
    private String materialName;

    @ExcelProperty("物料价格")
    private BigDecimal materialPrice;

    /**
     * 物料单位(字典)
     */
    @ExcelIgnore
    private String materialUnit;

    @ExcelProperty("物料单位")
    private String materialUnitName;

    @ExcelProperty("数量")
    private Long num;

    @ExcelProperty("预估销售额")
    private BigDecimal forecastSalesAmount;

    @ExcelProperty("费用申请金额")
    private BigDecimal applyAmount;
    /**
     * 支付方式集合
     */
    @ExcelIgnore
    private List<DictItemVo> payTypes;

    /**
     * 支付方式
     */
    @ExcelIgnore
    private String payType;

    @ExcelProperty("支付方式")
    private String payTypeName;

    @ExcelProperty("备注")
    private String remarks;
}
