package com.biz.crm.excel.vo.tpm.budgetgeneraterule;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.common.AbstractImportVo;
import com.alibaba.excel.annotation.ExcelProperty;
import com.biz.crm.excel.vo.MdmPropertyImportVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/10 14:00
 * @description
 */
@Data
public class TpmBudgetGenerateRuleImportVo extends MdmPropertyImportVo {

    @ExcelProperty("是否生成费用预算")
    private String isGenerate;

    @ExcelProperty("渠道名称")
    private String channelName;

    @ExcelIgnore
    private String channel;

    @ExcelIgnore
    private String customerName;

    @ExcelProperty("比例")
    private BigDecimal ratio;
    /**
     * 预算生成维度字典值
     */
    @ExcelIgnore
    private String feeBudgetType;

    @ExcelProperty("预算生成维度")
    private String feeBudgetTypeName;

    @ExcelProperty("月份")
    private String month;

    @ExcelProperty("年度")
    private String year;
    /**
     * 预算科目名称
     */
    @ExcelIgnore
    private String budgetSubjectName;

    @ExcelProperty("预算科目编码")
    private String budgetSubjectCode;
    /**
     * 预算规则编码
     */
    @ExcelIgnore
    private String budgetRuleCode;

    @ExcelProperty("预算规则名称")
    private String budgetRuleName;


    public String getUniqueKey(){
        return feeBudgetType + budgetSubjectCode + "-" + year + "-" + month + "-" + getOrgCode() + "-" + getCustomerCode() + "-" +getTerminalCode() + "-" + channel;
    }
}
