package com.biz.crm.excel.vo.tpm.incomebudget;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.biz.crm.excel.vo.MdmPropertyImportVo;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/14 13:45
 * @description
 */
@Data
public class TpmIncomeBudgetImportVo extends MdmPropertyImportVo {

    @ExcelProperty("预算分组")
    private String feeBudgetTypeName;

    @ExcelProperty("收入预算名称")
    private String incomeName;

    @ExcelProperty("预算年份")
    private String budgetYear;

    @ExcelProperty("预算月份")
    private String budgetMonth;

    @ExcelIgnore
    private String productName;

    @ExcelIgnore
    private String feeBudgetType;

    @ExcelIgnore
    private String productLevelName;

    @ExcelIgnore
    private String channel;

    @ExcelProperty("渠道")
    private String channelName;

    @ExcelProperty("产品层级编码")
    private String productLevelCode;

    @ExcelProperty("产品编码")
    private String productCode;

    @ExcelProperty("金额")
    private BigDecimal initAmount;

}
