package com.biz.crm.excel.vo.tpm.invoice;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.biz.crm.common.AbstractImportVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/16 17:17
 * @description
 */
@Data
public class TpmInvoiceImportVo extends AbstractImportVo {
    @ExcelIgnore
    private String invoiceType;

    @ExcelProperty("发票类型")
    private String invoiceTypeName;

    @ExcelProperty("发票代码")
    private String invoiceCode;

    @ExcelProperty("发票号码")
    private String invoiceNumber;

    @ExcelProperty("开票日期")
    private String invoicingDate;

    @ExcelProperty("校验码")
    private String checkCode;

    @ExcelProperty("买方名称")
    private String purchaserName;

    @ExcelProperty("买方纳税人号码")
    private String purchaserTaxpayerNumber;

    @ExcelProperty("买方地址及电话信息")
    private String purchaserInfo;

    @ExcelProperty("买方账户")
    private String purchaserAccount;

    @ExcelProperty("卖方名称")
    private String sellerName;

    @ExcelProperty("卖方纳税人号码")
    private String sellerTaxpayerNumber;

    @ExcelProperty("卖方地址及电话信息")
    private String sellerInfo;

    @ExcelProperty("卖方账户")
    private String sellerAccount;

    @ExcelProperty("金额")
    private BigDecimal amount;

    @ExcelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ExcelIgnore
    private BigDecimal taxAmount;
    /**
     * 含税总金额
     */
    @ExcelProperty("税价合计")
    private BigDecimal totalAmount;

    @ExcelIgnore
    private BigDecimal usedAmount;

    @ExcelIgnore
    private BigDecimal availableAmount;
}