package com.biz.crm.excel.vo.tpm.salesplans;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.biz.crm.common.AbstractImportVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @description: 销售计划导入vo
 * @author: rentao
 * @date: 2021/10/28 16:50
 */
@Data
public class TpmSalesPlansImportVo extends AbstractImportVo {


  @ColumnWidth(20)
  @ExcelProperty(value = "年份(必填)")
  private String spYear;


  @ColumnWidth(20)
  @ExcelProperty(value = "月份(必填)")
  private String spMonth;


  @ColumnWidth(20)
  @ExcelProperty(value = "销售计划类型(必填)")
  private String spType;


  @ColumnWidth(20)
  @ExcelProperty(value = "渠道编码(必填)")
  private String channelCode;


  @ColumnWidth(20)
  @ExcelProperty(value = "渠道名称")
  private String channelName;


  @ColumnWidth(20)
  @ExcelProperty(value = "组织编码")
  private String orgCode;


  @ColumnWidth(20)
  @ExcelProperty(value = "组织名称")
  private String orgName;


  @ColumnWidth(20)
  @ExcelProperty(value = "客户编码")
  private String customerCode;


  @ColumnWidth(20)
  @ExcelProperty(value = "客户名称")
  private String customerName;


  @ColumnWidth(20)
  @ExcelProperty(value = "产品层级编码(必填)")
  private String productLevelCode;


  @ColumnWidth(20)
  @ExcelProperty(value = "产品层级名称")
  private String productLevelName;


  @ColumnWidth(20)
  @ExcelProperty(value = "产品编码")
  private String productCode;


  @ColumnWidth(20)
  @ExcelProperty(value = "产品名称")
  private String productName;


  @ColumnWidth(20)
  @ExcelProperty(value = "金额(必填)")
  private BigDecimal amount;

  /**
   * 岗位编码
   */
  @ExcelIgnore
  private String positionCode;

  /**
   * 岗位名称
   */
  @ExcelIgnore
  private String positionName;

  /**
   * 币种
   */
  @ExcelIgnore
  private String currencyTypes;

  /**
   * 销售计划id
   */
  @ExcelIgnore
  private String salePlansId;

}

