package com.biz.crm.fee.pool.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 费用池明细表实体类
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("fee_pool_detail")
@CrmTable(name = "fee_pool_detail", tableNote = "费用池明细表", indexes = {
        @Index(name = "uk_f_detail_pool_detail_code", unique = true, columnList = "pool_detail_code"),
        @Index(name = "uk_f_detail_pool_code", columnList = "pool_code"),
        @Index(name = "uk_f_detail_operation_code", columnList = "operation_code")
})
public class FeePoolDetailEntity extends CrmExtTenEntity<FeePoolDetailEntity> {

    @CrmColumn(name = "pool_code", nullable = false, length = 32, note = "费用池编号")
    private String poolCode;

    @CrmColumn(name = "pool_detail_code", nullable = false, unique = true, length = 32, note = "费用池明细编号")
    private String poolDetailCode;

    @CrmColumn(name = "operation_code", nullable = false, length = 32, note = "操作记录编号")
    private String operationCode;

    @CrmColumn(name = "operation_type", nullable = false, length = 8, note = "操作类型")
    private String operationType;

    @CrmColumn(name = "from_code", length = 64, note = "来源编号")
    private String fromCode;

    @CrmColumn(name = "from_desc", length = 64, note = "来源描述")
    private String fromDesc;

    @CrmColumn(name = "account_date_time", nullable = false, length = 19, note = "上账时间 yyyy-MM-dd HH:mm:ss")
    private String accountDateTime;

    @CrmColumn(name = "total_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "总金额（数量）")
    private BigDecimal totalAmount;

    @CrmColumn(name = "freeze_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "冻结金额（数量）")
    private BigDecimal freezeAmount;

    @CrmColumn(name = "occupy_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", defaultValue = "0.000000", note = "占用金额（数量）")
    private BigDecimal occupyAmount;

    @CrmColumn(name = "has_use_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "已使用金额（数量）")
    private BigDecimal hasUseAmount;

    @CrmColumn(name = "usable_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "剩余可使用金额（数量）")
    private BigDecimal usableAmount;

    @CrmColumn(name = "act_code", length = 32, note = "活动编码")
    private String actCode;

    @CrmColumn(name = "act_name", length = 128, note = "活动名称")
    private String actName;

    @CrmColumn(name = "act_detail_code", length = 32, note = "活动明细编码")
    private String actDetailCode;

    @CrmColumn(name = "act_type", length = 32, note = "活动类型")
    private String actType;

    @CrmColumn(name = "fine_code", length = 32, note = "活动细类编码")
    private String fineCode;

    @CrmColumn(name = "fine_name", length = 128, note = "活动细类名称")
    private String fineName;

    @CrmColumn(name = "categories_code", length = 32, note = "活动大类编码")
    private String categoriesCode;

    @CrmColumn(name = "categories_name", length = 128, note = "活动大类名称")
    private String categoriesName;

    @CrmColumn(name = "budget_subjects_code", length = 32, note = "会计科目编码")
    private String budgetSubjectsCode;

    @CrmColumn(name = "budget_subjects_name", length = 128, note = "会计科目名称")
    private String budgetSubjectsName;

    @CrmColumn(name = "audit_code", length = 32, note = "核销编码")
    private String auditCode;

    @CrmColumn(name = "audit_detail_code", length = 32, note = "核销明细编码")
    private String auditDetailCode;

}
