package com.biz.crm.fee.pool.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 费用池主表实体类
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("fee_pool")
@CrmTable(name = "fee_pool", tableNote = "费用池主表实体表", indexes = {
        @Index(name = "uk_f_pool_code", unique = true, columnList = "pool_code"),
        @Index(name = "uk_f_customer_code", columnList = "customer_code")
})
public class FeePoolEntity extends CrmBaseEntity<FeePoolEntity> {

    @CrmColumn(name = "pool_group", nullable = false, defaultValue = "'default'", length = 32, note = "费用池分组")
    private String poolGroup;

    @CrmColumn(name = "pool_code", nullable = false, unique = true, length = 32, note = "费用池编号")
    private String poolCode;

    @CrmColumn(name = "pool_type", nullable = false, length = 32, note = "费用池类型")
    private String poolType;

    @CrmColumn(name = "pay_type", nullable = false, length = 32, note = "支付方式")
    private String payType;

    @CrmColumn(name = "use_type", length = 32, nullable = false, defaultValue = "'default'", note = "费用使用类型")
    private String useType;

    @CrmColumn(name = "customer_code", nullable = false, length = 32, note = "客户编码")
    private String customerCode;

    @CrmColumn(name = "customer_name", nullable = false, length = 128, note = "客户名称")
    private String customerName;

    @CrmColumn(name = "channel_type", length = 32, note = "渠道类型（项目上自行存值）")
    private String channelType;

    @CrmColumn(name = "org_code", length = 255, note = "组织编码（项目上自行存值）")
    private String orgCode;

    @CrmColumn(name = "org_name", length = 500, note = "组织名称（项目上自行存值）")
    private String orgName;

    @CrmColumn(name = "erp_code", length = 64, note = "erp编码（项目上自行存值）")
    private String erpCode;

    @CrmColumn(name = "sale_company_code", length = 64, note = "销售公司编码（项目上自行存值）")
    private String saleCompanyCode;

    @CrmColumn(name = "goods_product_level_code", length = 32, note = "货补产品层级编码")
    private String goodsProductLevelCode;

    @CrmColumn(name = "goods_product_level_name", length = 128, note = "货补产品层级名称")
    private String goodsProductLevelName;

    @CrmColumn(name = "goods_product_code", length = 255, note = "货补商品编码(集合，排序后英文逗号间隔)")
    private String goodsProductCode;

    @CrmColumn(name = "goods_product_name", length = 500, note = "货补商品名称(集合，排序后英文逗号间隔)")
    private String goodsProductName;

    @CrmColumn(name = "total_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "总金额（数量）")
    private BigDecimal totalAmount;

    @CrmColumn(name = "freeze_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "冻结金额（数量）")
    private BigDecimal freezeAmount;

    @CrmColumn(name = "occupy_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)",defaultValue = "0.000000", note = "占用金额（数量）")
    private BigDecimal occupyAmount;

    @CrmColumn(name = "has_use_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "已使用金额（数量）")
    private BigDecimal hasUseAmount;

    @CrmColumn(name = "usable_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "剩余可使用金额（数量）")
    private BigDecimal usableAmount;

    @CrmColumn(name = "pool_ext1", length = 128, note = "费用池主表预留字段1")
    private String poolExt1;

    @CrmColumn(name = "pool_ext2", length = 128, note = "费用池主表预留字段2")
    private String poolExt2;

    @CrmColumn(name = "pool_ext3", length = 128, note = "费用池主表预留字段3")
    private String poolExt3;

    @CrmColumn(name = "pool_ext4", length = 128, note = "费用池主表预留字段4")
    private String poolExt4;

    @CrmColumn(name = "pool_ext5", length = 128, note = "费用池主表预留字段5")
    private String poolExt5;

    @CrmColumn(name = "pool_ext6", length = 255, note = "费用池主表预留字段6")
    private String poolExt6;

    @CrmColumn(name = "pool_ext7", length = 255, note = "费用池主表预留字段7")
    private String poolExt7;

    @CrmColumn(name = "pool_ext8", length = 255, note = "费用池主表预留字段8")
    private String poolExt8;

    @CrmColumn(name = "pool_ext9", length = 255, note = "费用池主表预留字段9")
    private String poolExt9;

    @CrmColumn(name = "pool_ext10", length = 255, note = "费用池主表预留字段10")
    private String poolExt10;


}
