package com.biz.crm.fee.pool.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 费用池操作记录表实体类
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("fee_pool_operation")
@CrmTable(name = "fee_pool_operation", tableNote = "费用池操作记录表", indexes = {
        @Index(name = "i_f_opt_pool_code", columnList = "pool_code"),
        @Index(name = "uk_f_opt_operation_code", unique = true, columnList = "operation_code")
})
public class FeePoolOperationEntity extends CrmBaseEntity<FeePoolOperationEntity> {

    @CrmColumn(name = "pool_code", nullable = false, length = 32, note = "费用池编号")
    private String poolCode;

    @CrmColumn(name = "operation_code", nullable = false, length = 32, note = "操作记录编号")
    private String operationCode;

    @CrmColumn(name = "operation_type", nullable = false, length = 32, note = "操作类型")
    private String operationType;

    @CrmColumn(name = "from_code", length = 128, note = "来源编号")
    private String fromCode;

    @CrmColumn(name = "from_desc", length = 128, note = "来源描述")
    private String fromDesc;

    @CrmColumn(name = "operation_date_time", nullable = false, length = 19, note = "操作时间 yyyy-MM-dd HH:mm:ss")
    private String operationDateTime;

    @CrmColumn(name = "operation_amount", nullable = false, mysqlType = "decimal(18,6)", oracleType = "NUMBER(18, 6)", note = "操作金额（数量）（含正负）")
    private BigDecimal operationAmount;

}
