package com.biz.crm.kms.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @Project crm
 * @PackageName com.biz.crm.config
 * @ClassName KmsConfig
 * @Author Gavin
 * @Date 2021/4/13 下午3:30
 * @Description kms后台配置
 */
@Getter
@Setter
@Configuration
@ConfigurationProperties(prefix = "kms.config")
public class KmsConfig {
    /**
     * 请求地址
     */
    private String addr;

    /**
     * 租户ID
     */
    private String tenantryId;

    /**
     * Aes加密解密key
     */
    private String encryptAesKey;

    /**
     * ka-flag
     */
    private String kaFlag;
}