package com.biz.crm.kms.eunm;


import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author maoshen
 * @date 2021/5/28.
 */
public enum ProductUnitEnum {
    BAG("bag", "箱"),
    BOX("box", "盒"),
    BOTTLE("bottle", "瓶子");
    /***编码规则key*/
    private String code;
    private String desc;

    ProductUnitEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static Map<String, String> unitMap() {
        Map<String, String> unitMap = Maps.newHashMap();
        unitMap.put(BAG.code, BAG.desc);
        unitMap.put(BOX.code, BOX.desc);
        unitMap.put(BOTTLE.code, BOTTLE.desc);
        return unitMap;
    }

}
