package com.biz.crm.kms.kaproduct.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.excel.vo.kms.kaproduct.KmsTenantryDirectProductImportVo;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.kaproduct.model.KmsTenantryDirectProductEntity;
import com.biz.crm.nebular.kms.kaproduct.req.KmsTenantryDirectProductReqVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/5/27.
 */
public interface KmsTenantryDirectProductMapper extends BaseMapper<KmsTenantryDirectProductEntity> {


    /**
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductEntity> selectListForExcel(@Param("vo") KmsTenantryDirectProductReqVo reqVo);

    /**
     * 查询数据库是否重复数据
     *
     * @param vo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectProductEntity> checkRepeat(@Param("vo") KmsTenantryDirectProductImportVo vo);
}
