package com.biz.crm.kms.tenantrydirectstore.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.kms.supermarket.req.KmsTenantryDirectStoreReqVo;
import com.biz.crm.nebular.kms.supermarket.resp.KmsTenantryDirectStoreRespVo;
import com.biz.crm.supermarket.model.KmsTenantryDirectStoreEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author maoshen
 * @date 2021/4/27.
 */
public interface KmsTenantryDirectStoreMapper extends BaseMapper<KmsTenantryDirectStoreEntity> {

    /**
     * 条件查询 数据权限
     *
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectStoreEntity> selectListByCompetence(@Param("vo") KmsTenantryDirectStoreReqVo reqVo);

    @SqlPrivilege(posCode = "t.create_pos_code", orgCode = "t.create_org_code")
    List<KmsTenantryDirectStoreRespVo> findList(Page<KmsTenantryDirectStoreRespVo> page, @Param("vo") KmsTenantryDirectStoreReqVo kmsTenantryDirectStoreReqVo);

}
