package com.biz.crm.mdm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 客户信息：收货地址实体类
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_address")
public class MdmCustomerAddressEntity extends CrmTreeEntity<MdmCustomerAddressEntity> {


    /**
     * 市
     */
    private String cityCode;

    /**
     * 区
     */
    private String districtCode;

    /**
     * 省
     */
    private String provinceCode;

    /**
     * 送达方编码
     */
    private String destinationCode;

    /**
     * 送达方名称
     */
    private String destinationName;

    /**
     * 详细地址
     */
    private String detailedAddress;

    /**
     * 联系人
     */
    private String contactName;

    /**
     * 联系电话
     */
    private String contactPhone;

    /**
     * 是否默认地址，1：是，0：否
     */
    private String defaultAddress;

    /**
     * 客户编码
     */
    private String customerCode;

    @ApiModelProperty("有效开始时间")
    private String startTime;

    @ApiModelProperty("有效结束时间")
    private String endTime;

}
