package com.biz.crm.mdm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 实体类
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_contact")
public class MdmCustomerContactEntity extends CrmTreeEntity<MdmCustomerContactEntity> {

    /**
     * 客户id
     */
    private String customerCode;

    /**
     * 联系人姓名
     */
    private String contactName;

    /**
     * 联系人电话
     */
    private String contactPhone;

    @ApiModelProperty("主联系人,1是0否")
    private String contactMain;

}
