package com.biz.crm.mdm.customer.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmTreeTenEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 客户信息销售区域实体类
 *
 * @author zxw
 * @date 2020-11-16 15:50:20
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("mdm_customer_sale_area")
public class MdmCustomerSaleAreaEntity extends CrmTreeTenEntity<MdmCustomerSaleAreaEntity> {


    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 一级区域
     */
    private String areaOne;

    /**
     * 二级区域
     */
    private String areaTwo;

    @ApiModelProperty("三级区域")
    private String areaThree;

}
